<div class="">
    <div class="content mx-auto">
        <div class="ps-xl-0 ps-3 mt-3">
            <h3><?php echo e(count($labs)); ?> &nbsp;<?php echo e(__('Laboratory available')); ?></h3>
            <p class="mt-2"><?php echo e(__('Book Your Appointment with Easy Way')); ?></p>
        </div>
    </div>
</div>

<div class="content mx-auto">
    <div class="row row-cols-1 row-cols-lg-2 g-0">
        <?php if(count($labs) > 0): ?>
            <?php $__currentLoopData = $labs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col">
                    <div class="doct-card p-3 card border-0 m-3  ms-xl-0 pb-2 mb-0 position-relative lab_card">
                        <div class="d-flex flex-sm-row flex-column">
                            <div class="doct-card-img me-3 lab_card_img">
                                <img src="<?php echo e($lab->fullImage); ?>">
                            </div>
                            <div class=" doctor-info d-flex flex-column w-100">
                                <div class="personalInfo">
                                    <div>
                                        <h6><?php echo e($lab->name); ?></h6>
                                    </div>
                                    <div class="d-flex mt-3  text-center">
                                        <i class='bx bxs-phone-call'></i>
                                        <p class="mb-0 ps-1"><?php echo e($lab['user']->phone); ?></p>
                                    </div>
                                    <div class="d-flex mt-2 align-items-center fbk ">
                                        <i class='bx bx-mail-send'></i>
                                        <p><?php echo e($lab['user']->email); ?></p>
                                    </div>
                                    <div class="d-flex mt-2 align-items-center ">
                                        <i class='bx bxs-door-open'></i>
                                        <p><?php echo e(__('Opens At')); ?>&nbsp;<?php echo e($lab->openTime); ?></p>
                                    </div>
                                </div>
                                <div class="location mt-2 mb-2 d-flex">
                                    <i class='bx bx-map'></i>
                                    <p><?php echo e($lab->address); ?></p>
                                </div>
                                <div class="my-3 w-100">
                                    <div class="btn-appointment text-end mt-sm-0 mt-3">
                                        <a class="btn btn-link text-center mt-0" href="<?php echo e(url('lab_tests/'.$lab->id.'/'.Str::slug($lab->name))); ?>" role="button"><?php echo e(__('Test Report')); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <div class="w-100 text-center">
                <i class='bx bxs-shopping-bag noData'></i>
                <br>
                <h6 class="mt-3"><?php echo e(__('Laboratory Not Available.')); ?></h6>
            </div> 
        <?php endif; ?>
    </div>
</div><?php /**PATH /home/penastud/public_html/doktro/resources/views/website/lab/display_lab.blade.php ENDPATH**/ ?>