<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(url('assets/plugins/dropzone/dropzone.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title',__('All Hospital')); ?>
<?php $__env->startSection('content'); ?>

<section class="section">
    <?php echo $__env->make('layout.breadcrumb',[
        'title' => __('hospital Gallery'),
        'url' => url('hospital'),
        'urlTitle' => __('Hospital'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php if(session('status')): ?>
        <?php echo $__env->make('superAdmin.auth.status',[
            'status' => session('status')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <form method="post" action="<?php echo e(url('hospitalGallery')); ?>" enctype="multipart/form-data" id="mydropzone" class="dropzone">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="hospital_id" value="<?php echo e($hospital->id); ?>">
                </form>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <div class="upload-wrap">
                    <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="upload-images">
                            <a href="<?php echo e($gallery->fullImage); ?>" data-fancybox="gallery2">
                                <img src="<?php echo e(url($gallery->fullImage)); ?>" alt="Upload Image">
                            </a>
                            <a href="javascript:void(0);" onclick="deleteData('hospitalGallery',<?php echo e($gallery->id); ?>)" class="btn btn-icon btn-danger btn-sm"><i class="far fa-trash-alt"></i></a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(url('assets/plugins/dropzone/dropzone.min.js')); ?>"></script>
    <script>
        "use strict";
        var totalSteps;
        var dropzone = new Dropzone("#mydropzone", {
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layout.mainlayout_admin',['activePage' => 'hospital'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/doktro/resources/views/superAdmin/hospital/hospital_gallery.blade.php ENDPATH**/ ?>