

<?php $__env->startSection('title',__('Radiology')); ?>

<?php $__env->startSection('content'); ?>
<section class="section">
    <?php echo $__env->make('layout.breadcrumb',[
        'title' => __('Radiology'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="section_body">
        <?php if(session('status')): ?>
        <?php echo $__env->make('superAdmin.auth.status',[
            'status' => session('status')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <div class="card">
            <div class="card-header w-100 text-right d-flex justify-content-between">
                <?php echo $__env->make('superAdmin.auth.exportButtons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('radiology_add')): ?>
                    <a href="<?php echo e(url('radiology/create')); ?>"><?php echo e(__('Add New')); ?></a>                
                <?php endif; ?>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="datatable table table-hover table-center mb-0">
                        <thead>
                            <tr>
                                <th>
                                    <input name="select_all" value="1" id="master" type="checkbox" />
                                    <label for="master"></label>
                                </th>
                                <th>#</th>
                                <?php if(auth()->user()->hasRole('super admin')): ?>
                                    <th><?php echo e(__('laboratory name')); ?></th>
                                <?php endif; ?>
                                <th><?php echo e(__('radiology Category name')); ?></th>
                                <th><?php echo e(__('Report Days')); ?></th>
                                <th><?php echo e(__('Charge')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <?php if(Gate::check('radiology_edit') || Gate::check('radiology_delete')): ?>
                                    <th><?php echo e(__('Actions')); ?></th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $radiologies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $radiology): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <input type="checkbox" name="id[]" value="<?php echo e($radiology->id); ?>" id="<?php echo e($radiology->id); ?>" data-id="<?php echo e($radiology->id); ?>" class="sub_chk">
                                        <label for="<?php echo e($radiology->id); ?>"></label>
                                    </td>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <?php if(auth()->user()->hasRole('super admin')): ?>
                                        <td><?php echo e($radiology->lab['name']); ?></td>
                                    <?php endif; ?>
                                    <td><?php echo e($radiology->radiology_category['name']); ?></td>
                                    <td><?php echo e($radiology->report_days); ?></td>
                                    <td><?php echo e($currency); ?><?php echo e($radiology->charge); ?></td>
                                    <td>
                                        <label class="cursor-pointer">
                                            <input type="checkbox"id="status_1<?php echo e($radiology->id); ?>" class="custom-switch-input" onchange="change_status('radiology',<?php echo e($radiology->id); ?>)" <?php echo e($radiology->status == 1 ? 'checked' : ''); ?>>
                                            <span class="custom-switch-indicator"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <?php if(Gate::check('radiology_edit') || Gate::check('radiology_delete')): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('radiology_edit')): ?>
                                            <a class="text-success" href="<?php echo e(url('radiology/'.$radiology->id.'/edit')); ?>">
                                                <i class="far fa-edit"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('radiology_delete')): ?>
                                            <a class="text-danger" href="javascript:void(0);" onclick="deleteData('radiology',<?php echo e($radiology->id); ?>)">
                                                <i class="far fa-trash-alt"></i>
                                            </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card_fotter">
                <input type="button" value="delete selected" onclick="deleteAll('radiology_all_delete')" class="btn btn-primary">
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.mainlayout_admin',['activePage' => 'radiology'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/doktro/resources/views/lab/radiology/radiology.blade.php ENDPATH**/ ?>