

<?php $__env->startSection('title',__('Laboratory')); ?>

<?php $__env->startSection('content'); ?>
<section class="section">
    <?php echo $__env->make('layout.breadcrumb',[
        'title' => __('Laboratory'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="section_body">
        <?php if(session('status')): ?>
        <?php echo $__env->make('superAdmin.auth.status',[
            'status' => session('status')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <div class="card">
            <div class="card-header w-100 text-right d-flex justify-content-between">
                <?php echo $__env->make('superAdmin.auth.exportButtons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lab_add')): ?>
                    <a href="<?php echo e(url('laboratory/create')); ?>"><?php echo e(__('Add New')); ?></a>                
                <?php endif; ?>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="datatable table table-hover table-center mb-0">
                        <thead>
                            <tr>
                                <th>
                                    <input name="select_all" value="1" id="master" type="checkbox" />
                                    <label for="master"></label>
                                </th>
                                <th>#</th>
                                <th><?php echo e(__('Laboratory Image')); ?></th>
                                <th><?php echo e(__('Laboratory Name')); ?></th>
                                <th><?php echo e(__('Pathologist Name')); ?></th>
                                <th><?php echo e(__('Pathologist email')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <?php if(Gate::check('lab_edit') || Gate::check('lab_delete')): ?>
                                    <th><?php echo e(__('Actions')); ?></th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $labs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <input type="checkbox" name="id[]" value="<?php echo e($lab->id); ?>" id="<?php echo e($lab->id); ?>" data-id="<?php echo e($lab->id); ?>" class="sub_chk">
                                        <label for="<?php echo e($lab->id); ?>"></label>
                                    </td>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <img class="avatar-img rounded-circle" width="50px" height="50px" src="<?php echo e($lab->fullImage); ?>" alt="doctor Image"></a>
                                    </td>
                                    <td><?php echo e($lab->name); ?></td>
                                    <td><?php echo e($lab->user['name']); ?></td>
                                    <td>
                                        <a href="mailto:<?php echo e($lab->user['email']); ?>">
                                            <span class="text_transform_none"><?php echo e($lab->user['email']); ?></span>
                                        </a>
                                    </td>
                                    <td>
                                        <label class="cursor-pointer">
                                            <input type="checkbox"id="status_1<?php echo e($lab->id); ?>" class="custom-switch-input" onchange="change_status('lab',<?php echo e($lab->id); ?>)" <?php echo e($lab->status == 1 ? 'checked' : ''); ?>>
                                            <span class="custom-switch-indicator"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <?php if(Gate::check('lab_edit') || Gate::check('lab_delete')): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lab_edit')): ?>
                                            <a class="text-success" href="<?php echo e(url('laboratory/'.$lab->id.'/edit')); ?>">
                                                <i class="far fa-edit"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lab_delete')): ?>
                                            <a class="text-danger" href="javascript:void(0);" onclick="deleteData('laboratory',<?php echo e($lab->id); ?>)">
                                                <i class="far fa-trash-alt"></i>
                                            </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card_fotter">
                <input type="button" value="delete selected" onclick="deleteAll('lab_all_delete')" class="btn btn-primary">
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.mainlayout_admin',['activePage' => 'lab'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/doktro/resources/views/superAdmin/lab/lab.blade.php ENDPATH**/ ?>