

<?php $__env->startSection('title',$doctor->name.' Profile'); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white">
        <div class="content mx-auto">
            <div class="d-flex flex-lg-row flex-column">
                <form method="post" action="<?php echo e(url('show-doctors')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="single_doctor" value="<?php echo e(__('single_doctor')); ?>">
                    <input type="hidden" name="doc_lat">
                    <input type="hidden" name="doc_lang">
                    <div class="ps-xl-0 ps-3 d-flex flex-md-row flex-column serach-box">
                        <div class="location position-relative mb-md-0 mb-3 ">
                            <input type="search" class="form-control loc"  onFocus="geolocate()" id="autocomplete" name="doctor_location" aria-describedby="helpId" placeholder="<?php echo e(__('Search Location')); ?>">
                            <i class='bx bx-map position-absolute bx_icons'></i>
                        </div>
                        <div class="location doc position-relative d-flex">
                            <input type="search" class="form-control docto" name="search_doctor" aria-describedby="helpId" placeholder="<?php echo e(__('Search doctors, clinics, hospitals, etc.')); ?>">
                            <div class="location position-relative">
                                <button type="submit" class="btn btn-primary ml-2">
                                    <i class='bx bx-search-alt-2'></i>
                                </button>
                            </div>
                            <i class='bx bx-search position-absolute bx_icons'></i>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="full-content">
        <div class="content px-lg-0 px-2 py-3 mx-auto">
            <div class="row">
                <div class="col-lg-6">
                    <div class="doc-profile bg-white rounded-2 h-100 p-3">
                        <div class="d-flex  flex-sm-row flex-column align-items-sm-center">
                            <div class="doc-profile-img  pb-2  me-3">
                                <img src="<?php echo e($doctor->fullImage); ?>" class="rounded-circle " alt="">
                            </div>
                            <div class="doct-card doctor-info ">
                                <div class="personalInfo">
                                    <div>
                                        <h6><?php echo e($doctor->name); ?></h6>
                                    </div>
                                    <div class="post d-flex mt-1 align-items-center">
                                        <?php if(isset($doctor->expertise) && isset($doctor->category)): ?>
                                            <p class=" text-muted"><?php echo e($doctor->expertise['name']); ?>

                                            <img src="<?php echo e($doctor->category['fullImage']); ?>" class="ms-1 ps-1 mb-0 border-start" alt="">
                                            <p class="ps-2 mb-0"><?php echo e($doctor->category['name']); ?></p>
                                            </p>
                                        <?php endif; ?>
                                    </div>

                                    <div class="rating d-flex align-items-center">
                                        <?php for($i = 1; $i < 6; $i++): ?>
                                            <?php if($i <= $doctor['rate']): ?>
                                                <i class='bx bxs-star active'></i>
                                            <?php else: ?>
                                                <i class='bx bxs-star'></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                        <span class="d-inline-block average-rating">(<?php echo e($doctor['rate']); ?>)</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div>
                            <div class="d-flex mt-2 align-items-center ">
                                <i class="bx bx-money"></i>
                                <p class="ms-2"> <?php echo e($currency); ?> <span><?php echo e($doctor['appointment_fees']); ?></span></p>
                            </div>
                            <div class="d-flex mt-2 align-items-center fbk ">
                                <i class="bx bx-message-dots"></i>
                                <p class="ms-2"> <span><?php echo e($doctor['review']); ?></span> <?php echo e(__(' Feedback')); ?></p>
                            </div>

                            <div class="location my-2 d-flex">
                                
                            </div>
                            <div class="doctor-info d-flex ">
                                <div class="btn-appointment ms-auto mt-sm-0 mt-3">
                                    <a class="btn btn-link text-center mt-0"
                                        href="<?php echo e(url('booking/'.$doctor->id.'/'.Str::slug($doctor->name))); ?>" role="button"><?php echo e(__('Book Appointment')); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="col-lg-6">
                    <div class="schedule bg-white rounded-3 h-100 ">
                        <div class="d-flex align-items-center border-bottom p-3">
                            <i class='bx bx-calendar-plus vid-icon text-center'></i>
                            <h6 class="ms-2"><?php echo e(__('Doctor Availablity')); ?></h6>
                        </div>
                        <div class="d-flex book-slot shadow-sm">
                            <div class="w-50 d-flex p-2 align-items-center justify-content-center flex-column border-end" onclick="seeData('#toDays')">
                                <p><?php echo e(__('Today')); ?></p>
                                <p class="available"><?php echo e(count($today_timeslots)); ?> <?php echo e(__('Slots Available')); ?></p>
                            </div>
                            <div class="w-50 d-flex p-2 align-items-center justify-content-center border-start flex-column" onclick="seeData('#tomorrows')">
                                <p><?php echo e(__('Tomorrow')); ?></p>
                                <p class="available"><?php echo e(count($tomorrow_timeslots)); ?> <?php echo e(__('Slots Available')); ?></p>
                            </div>
                        </div>

                        <div class="p-3 todays_slot pt-2 ">
                            <div id="toDays" class="disp-none disp-block">
                                <h6 class="mb-3 mt-2"><?php echo e(__("Today's Schedule")); ?></h6>
                                <div class="mt-2 slotes d-flex ">
                                    <?php $__currentLoopData = $today_timeslots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $today_timeslot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="m-1 d-flex time <?php echo e($loop->iteration == 1 ? 'active' : ''); ?> rounded-3">
                                            <form method="POST" action="<?php echo e(url('set_time')); ?>">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="doctor_id" value="<?php echo e($doctor->id); ?>">
                                                <input type="hidden" name="date" value="<?php echo e(\Carbon\Carbon::today()->format('Y-m-d')); ?>">
                                                <input type="hidden" name="time" value="<?php echo e($today_timeslot['start_time']); ?>">
                                                <button type="submit" class="noBorderbutton"><?php echo e($today_timeslot['start_time']); ?></button>
                                            </form>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <div id="tomorrows" class="disp-none ">
                                <h6 class="mb-3 mt-2"><?php echo e(__('Tomorrow Schedule')); ?></h6>
                                <div class="mt-2 slotes d-flex ">
                                    <?php $__currentLoopData = $tomorrow_timeslots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tomorrow_timeslot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="m-1 d-flex time <?php echo e($loop->iteration == 1 ? 'active' : ''); ?> rounded-3">
                                            <form method="POST" action="<?php echo e(url('set_time')); ?>">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="doctor_id" value="<?php echo e($doctor->id); ?>">
                                                <input type="hidden" name="date" value="<?php echo e(\Carbon\Carbon::tomorrow()->format('Y-m-d')); ?>">
                                                <input type="hidden" name="time" value="<?php echo e($tomorrow_timeslot['start_time']); ?>">
                                                <button type="submit" class="noBorderbutton"><?php echo e($tomorrow_timeslot['start_time']); ?></button>
                                            </form>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Profile Info Over -->

            <div class="mt-3">

                <div class="py-2 bg-white rounded-2">
                    <div class="single-nav">
                        <ul class="d-flex justify-content-center border-bottom">
                            <li class="d-flex text-center active"><a href="javascript:void(0)" onclick="seeData('#doctor_information')" class="h-100 w-100"><?php echo e(__('Doctor Information')); ?></a></li>
                            <li class="d-flex text-center"><a href="javascript:void(0)" class="h-100 w-100" onclick="seeData('#Locations')"><?php echo e(__('Locations')); ?></a></li>
                            <li class="d-flex text-center"><a href="javascript:void(0)" class="h-100 w-100" onclick="seeData('#Reviews')"><?php echo e(__('Reviews')); ?></a></li>
                            <li class="d-flex text-center"><a href="javascript:void(0)" class="h-100 w-100" onclick="seeData('#Bus-hour')"><?php echo e(__('Business Hours')); ?></a>
                            </li>
                        </ul>
                    </div>

                    <div class="px-3 single-dis pt-3 pb-1">

                        <div id="doctor_information" class="disp-none disp-block">
                            <div class="border p-3 rounded-3">
                                <div class="mb-4">
                                    <h6 class="common_head"><?php echo e(__('Professional Bio')); ?></h6>
                                    <p><?php echo e($doctor->desc); ?></p>
                                </div>
                                <div>
                                    <h6 class="common_head"><?php echo e(__('Education')); ?></h6>
                                    <?php $__currentLoopData = json_decode($doctor->education); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $education): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="">
                                            <span><?php echo e($education->college); ?></span>
                                            <p class="text-muted"> <?php echo e($education->degree); ?></p>
                                            <p class="text-muted"> <?php echo e($education->year); ?></p>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <div class="mt-4">
                                    <h6 class="common_head"><?php echo e(__('Work & Experience')); ?></h6>
                                    <div class="">
                                        <p class="text-muted"><?php echo e($doctor->experience); ?> <?php echo e(__(' (Years)')); ?></p>
                                    </div>
                                </div>
                                <div class="mt-4">
                                    <h6 class="common_head"><?php echo e(__('Certificate')); ?></h6>
                                    <?php $__currentLoopData = json_decode($doctor->certificate); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $certificate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="">
                                            <p class="text-info "><?php echo e($certificate->certificate_year); ?></p>
                                            <p class="text-muted fs-6"><?php echo e($certificate->certificate); ?></p>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                            </div>
                        </div>

                        <div id="Locations" class="disp-none">
                            <div class="border rounded-3 mb-2 p-3">
                                <div class="d-flex flex-md-row flex-column">
                                    <div class="w-100">
                                        <div class="d-flex w-100 justify-content-between">
                                            <div>
                                                <?php $__currentLoopData = $doctor->hospital; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hospital): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="<?php echo e($loop->iteration != 1 ? 'mt-4' : ''); ?>">
                                                        <h6 class="common_head mb-1">
                                                            <?php echo e($hospital['name']); ?>

                                                        </h6>
                                                        <p><i class="bx bx-map me-2"></i><?php echo e($hospital['address']); ?></p>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                            <div>
                                                <h6 class="common_head"><?php echo e($currency); ?> <span><?php echo e($doctor->appointment_fees); ?></span></h6>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="Reviews" class="disp-none">
                            <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="p-3 border rounded-3 mb-2">
                                    <div class="review-img d-flex w-100">
                                        <div>
                                            <img src="<?php echo e($review->user['fullImage']); ?>" class="rounded-circle me-3" alt="">
                                        </div>
                                        <div>
                                            <div>
                                                <h6 class="common_head mb-0"><?php echo e($review->user['name']); ?></h6>
                                                <div class="rating d-flex align-items-center">
                                                    <?php for($i = 1; $i < 6; $i++): ?>
                                                        <?php if($i <= $review->rate): ?>
                                                            <i class="bx bxs-star active"></i>
                                                        <?php else: ?>
                                                            <i class="bx bxs-star"></i>
                                                        <?php endif; ?>
                                                    <?php endfor; ?>
                                                        <span class="d-inline-block average-rating">(<?php echo e($review->rate); ?>)</span>
                                                </div>
                                            </div>

                                            <p class="mt-3"><?php echo e($review->review); ?></p>
                                            <div class="mt-1">
                                                <p class="text-muted"><?php echo e($review->created_at->diffForHumans()); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div id="Bus-hour" class="disp-none">
                            <div class="border p-3 business_hour mx-auto rounded-3">
                                <?php $__currentLoopData = $doctor->workHour; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="d-flex day-cal w-100 mb-1 align-items-center">
                                        <p><?php echo e($hour->day_index); ?></p>
                                        <?php if($hour->status == 1): ?>
                                            <span class="ms-auto open">
                                                <?php $__currentLoopData = json_decode($hour->period_list); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php echo e($item->start_time); ?> - <?php echo e($item->end_time); ?>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </span>
                                        <?php else: ?>
                                            <span class="ms-auto closed">
                                                <?php echo e(__('close')); ?>

                                            </span>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(App\Models\Setting::first()->map_key); ?>&sensor=false&libraries=places"></script>
    <script src="<?php echo e(url('assets/js/doctor_list.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.mainlayout',['active_page' => 'single_doctor'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/doktro/resources/views/website/single_doctor.blade.php ENDPATH**/ ?>