

<?php $__env->startSection('title',$doctor->name.__(' appointment booking')); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <div class="full-content">
            <div class="content px-lg-0 px-2 py-3 mx-auto">
                <h3><?php echo e(__('Appointment Booking')); ?></h3>
                <div class="bg-white mt-3">
                    <div class="doc-profile Appointment-detail  bg-white rounded-3 h-100 p-3">
                        <!-- Doctor Profile -->
                        <input type="hidden" name="currency" value="<?php echo e($setting->currency_code); ?>">
                        <input type="hidden" name="company_name" value="<?php echo e($setting->business_name); ?>">
                        <input type="hidden" name="user_name" value="<?php echo e(auth()->user()->name); ?>">
                        <input type="hidden" name="email" value="<?php echo e(auth()->user()->email); ?>">
                        <input type="hidden" name="phone" value="<?php echo e(auth()->user()->phone); ?>">
                        <div class="d-flex  flex-sm-row flex-column align-items-sm-center">
                            <div class="doc-profile-img book-doc-img  me-3">
                                <img src="<?php echo e($doctor->fullImage); ?>" alt="">
                            </div>
                            <div class="doct-card  doctor-info mt-sm-0 mt-3">
                                <div class="personalInfo">
                                    <div>
                                        <h6><?php echo e($doctor['name']); ?></h6>
                                    </div>
                                    <div class="rating d-flex  align-items-center">
                                        <?php for($i = 1; $i < 6; $i++): ?>
                                            <?php if($i <= $doctor['rate']): ?>
                                                <i class='bx bxs-star active'></i>
                                            <?php else: ?>
                                                <i class='bx bxs-star'></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                        <span class="d-inline-block average-rating">(<?php echo e($doctor['rate']); ?>)</span>
                                    </div>
                                    
                                        
                                        
                                    
                                </div>
                            </div>
                        </div>
                        <!-- Doctor Profile Over -->

                        <!-- Stapper -->
                        <div class="mt-3">
                            <div class="progress-container">
                                <div class="progress" id="progress"></div>
                                <div class="circle progress_active">1</div>
                                <div class="circle">2</div>
                                <div class="circle">3</div>
                            </div>
                            <form action="" method="post" enctype="multipart/form-data" id="thisform">
                            <?php echo csrf_field(); ?>
                             <input type="hidden" name="doctor_id" value="<?php echo e($doctor->id); ?>">
                            <input type="hidden" name="payment_type" value="COD">
                            <input type="hidden" name="payment_status" value="0">
                            <input type="hidden" name="amount" value="<?php echo e($doctor->appointment_fees); ?>">
                            <input type="hidden" name="payment_token">
                            <input type="hidden" name="discount_price">
                            <input type="hidden" name="discount_id">
                                <div class="my-3 appointment-form px-2">
                                    <div id="step1" class="disp-block">
                                        <div class="appointment-form">
                                            <h5 class="common-heading mb-4"><?php echo e(__('Patient Details')); ?></h5>

                                            <div class="pb-4">
                                                <div class="row g-2">
                                                    <div class="col-md">
                                                        <div class="h-100 d-flex flex-column w-100  select-Sort">
                                                            <label for="" class="form-label mb-2"><?php echo e(__('Appointment For')); ?></label>
                                                            <select name="appointment_for" class="form-control <?php $__errorArgs = ['appointment_for'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="appointment_for">
                                                                <option value="my_self"><?php echo e(__('for me')); ?></option>
                                                                <option value="other"><?php echo e(__('Other')); ?></option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md">
                                                        <div>
                                                            <label for="" class="form-label mb-1"><?php echo e(__('Illness Information')); ?></label>
                                                            <input type="text" class="form-control" name="illness_information" aria-describedby="emailHelpId" placeholder="Illness Information">
                                                            <span class="invalid-div text-danger"><span class="illness_information"></span></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="pb-4">
                                                <div class="row g-2">
                                                    <div class="col-md">
                                                        <div>
                                                            <label for="" class="form-label mb-1"><?php echo e(__('Patient Name')); ?></label>
                                                            <input type="text" class="form-control <?php $__errorArgs = ['patient_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('patient_name')); ?>" name="patient_name">
                                                            <span class="invalid-div text-danger"><span class="patient_name"></span></span>
                                                        </div>
                                                    </div>
                                                    <div class="col-md">
                                                        <div>
                                                            <label for="" class="form-label mb-1"><?php echo e(__('Patient Age')); ?></label>
                                                            <input type="number" class="form-control <?php $__errorArgs = ['age'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" min="1" value="<?php echo e(old('age')); ?>" name="age" id="age">
                                                            <span class="invalid-div text-danger"><span class="age"></span></span>
                                                        </div>
                                                    </div>
                                                    <div class="col-md">
                                                        <div>
                                                            <label for="" class="form-label mb-1"><?php echo e(__('Phone number')); ?></label>
                                                            <input type="number" min="1" name="phone_no" value="<?php echo e(old('phone_no')); ?>" class="form-control <?php $__errorArgs = ['phone_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="phone_no">
                                                            <span class="invalid-div text-danger"><span class="phone_no"></span></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="pb-4">
                                                <div class="row g-2">
                                                    <div class="col-md">
                                                        <label for="" class="form-label mb-1"><?php echo e(__('Hospital')); ?></label>
                                                        <select name="hospital_id" class="form-control">
                                                            <option value=""><?php echo e(__('Select Hospital')); ?></option>
                                                            <?php $__currentLoopData = $doctor->hospital; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hospital): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($hospital->id); ?>"><?php echo e($hospital->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <span class="invalid-div text-danger"><span class="hospital_id"></span></span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="pb-4">
                                                <div class="d-flex">
                                                    <a href="javascript:void(0)" class="d-flex ms-auto" data-bs-toggle="modal" data-bs-target="#exampleModal"><?php echo e(__('Select Location')); ?></a>
                                                </div>
                                                <select class="form-select form-select-sm <?php $__errorArgs = ['patient_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="patient_address" id="patient_address" aria-label="Default select example">
                                                    <option value=""><?php echo e(__('Please select The Address')); ?></option>
                                                    <?php $__currentLoopData = $patient_addressess; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient_address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($patient_address->id); ?>"><?php echo e($patient_address->address); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <span class="invalid-div text-danger"><span class="patient_address"></span></span>
                                            </div>

                                            <div class="pb-4">
                                                <div class="row g-2">
                                                    <div class="col-md">
                                                        <div>
                                                            <label for="" class="form-label mb-1"><?php echo e(__('Any Side Effects Of The Drug?')); ?></label>
                                                            <input type="text" name="drug_effect" value="<?php echo e(old('drug_effect')); ?>" class="form-control  <?php $__errorArgs = ['drug_effect'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="drug_effect">
                                                            <span class="invalid-div text-danger"><span class="drug_effect"></span></span>
                                                        </div>
                                                    </div>
                                                    <div class="col-md">
                                                        <div>
                                                            <label for="" class="form-label mb-1"><?php echo e(__('Any Note For Doctor ??')); ?></label>
                                                            <input type="text" value="<?php echo e(old('note')); ?>"  class="form-control <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="note" id="note">
                                                            <span class="invalid-div text-danger"><span class="note"></span></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="pb-4">
                                                <p><?php echo e(__('Upload Patient Image & Report')); ?></p>
                                                <div class="row g-2">
                                                    <div class="col-md-4 col-sm-6 d-flex justify-content-center">
                                                        <div>
                                                            <div class="img_preview avta-prview-1 shadow mt-3">
                                                                <div class="position-relative">
                                                                    <input type="file" id="image1" name="report_image[]" class="d-none" accept=".png, .jpg, .jpeg">
                                                                    <div class="position-absolute upload-label shadow-sm rounded-circle">
                                                                        <label for="image1" class=" position-absolute mb-0"><i class='bx bx-image-add '></i></label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-4 col-sm-6 d-flex justify-content-center">
                                                        <div>
                                                            <div class="img_preview avta-prview-2 shadow mt-3">
                                                                <div class="position-relative">
                                                                    <input type="file" id="image2" name="report_image[]" class="d-none" accept=".png, .jpg, .jpeg">
                                                                    <div class="position-absolute upload-label shadow-sm rounded-circle">
                                                                        <label for="image2" class=" position-absolute mb-0"><i class='bx bx-image-add '></i></label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-4 col-sm-6 d-flex justify-content-center">
                                                        <div>
                                                            <div class="img_preview avta-prview-3 shadow mt-3">
                                                                <div class="position-relative">
                                                                    <input type="file" id="image3" name="report_image[]" class="d-none" accept=".png, .jpg, .jpeg">
                                                                    <div class="position-absolute upload-label shadow-sm rounded-circle">
                                                                        <label for="image3" class=" position-absolute mb-0"><i class='bx bx-image-add '></i></label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div id="step2" class="disp-none">
                                        <div class="d-flex ">
                                            <div class="todays_slot mx-auto">
                                                <div class="mb-3">
                                                    <label for="" class="form-label mb-1"><?php echo e(__('Appointment Date')); ?></label>
                                                    <input type="date" class="form-control <?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="date" value="<?php echo e(old('date',$date)); ?>" min="<?php echo e(Carbon\Carbon::now(env('timezone'))->format('Y-m-d')); ?>" name="date">
                                                    <span class="invalid-div text-danger"><span class="date"></span></span>
                                                </div>
                                                <div class="">
                                                    <div class="mt-2 slotes d-flex timeSlotRow">
                                                        <?php if(count($timeslots) > 0): ?>
                                                            <?php $__currentLoopData = $timeslots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timeslot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if(Session::has('time') && Session::has('doctor_id')): ?>
                                                                    <?php if(Session::get('doctor_id') == $doctor->id): ?>
                                                                        <input type="hidden" name="time" value="<?php echo e(Session::get('time')); ?>">
                                                                    <?php else: ?>
                                                                        <input type="hidden" name="time" value="<?php echo e($loop->iteration == 1 ? $timeslot['start_time'] : ''); ?>">
                                                                    <?php endif; ?>
                                                                <?php else: ?>
                                                                    <input type="hidden" name="time" value="<?php echo e($loop->iteration == 1 ? $timeslot['start_time'] : ''); ?>">
                                                                <?php endif; ?>

                                                                <?php if(Session::has('time') && Session::has('doctor_id')): ?>
                                                                    <?php if(Session::get('doctor_id') == $doctor->id): ?>
                                                                        <div class="m-1 d-flex time timing<?php echo e($loop->iteration); ?> <?php echo e(Session::get('time') == $timeslot['start_time'] ? 'active' : ''); ?> rounded-3" onclick="thisTime(<?php echo e($loop->iteration); ?>)">
                                                                            <a class="selectedClass<?php echo e($loop->iteration); ?>" href="javascript:void(0)"><?php echo e($timeslot['start_time']); ?></a>
                                                                        </div>
                                                                    <?php else: ?>
                                                                        <div class="m-1 d-flex time timing<?php echo e($loop->iteration); ?> <?php echo e($loop->iteration == 1 ? 'active' : ''); ?> rounded-3" onclick="thisTime(<?php echo e($loop->iteration); ?>)">
                                                                            <a class="selectedClass<?php echo e($loop->iteration); ?>" href="javascript:void(0)"><?php echo e($timeslot['start_time']); ?></a>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                <?php else: ?>
                                                                    <div class="m-1 d-flex time timing<?php echo e($loop->iteration); ?> <?php echo e($loop->iteration == 1 ? 'active' : ''); ?> rounded-3" onclick="thisTime(<?php echo e($loop->iteration); ?>)">
                                                                        <a class="selectedClass<?php echo e($loop->iteration); ?>" href="javascript:void(0)"><?php echo e($timeslot['start_time']); ?></a>
                                                                    </div>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php else: ?>
                                                            <strong class="text-danger text-center w-100"><?php echo e(__('At this time doctor is not availabel please change the date...')); ?></strong>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="step3" class="disp-none">
                                        <div class="p-3 pb-4 border rounded-3 mb-5">
                                            <label for="" class="form-label mb-1"><?php echo e(__('Offer Code')); ?></label>
                                            <input type="text" value="<?php echo e(old('offer_code')); ?>" class="form-control <?php $__errorArgs = ['offer_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="offer_code" id="offer_code">
                                        </div>
                                        <div class="row">
                                            <div class="col-md-7 col-lg-8">
                                                <div class="m-2 border rounded-3 p-3">
                                                    <h6><?php echo e(__('Payment Method')); ?></h6>
                                                    <?php if($setting->cod == 1): ?>
                                                        <div class="position-relative d-flex align-items-center my-1 mt-2">
                                                            <input type="radio" class="d-none custom_radio" value="cod" id="cod" name="payment" checked>
                                                            <label for="cod" class="position-absolute custom-radio"></label>
                                                            <label for="cod" class="ms-4 normal-label"><?php echo e(__('COD')); ?></label>
                                                        </div>
                                                    <?php endif; ?>

                                                    <?php if($setting->paypal == 1): ?>
                                                        <div class="position-relative d-flex align-items-center my-1 ">
                                                            <input type="radio" class="d-none custom_radio" value="paypal" id="paypal" name="payment">
                                                            <label for="paypal" class="position-absolute custom-radio"></label>
                                                            <label for="paypal" class="ms-4 normal-label"><?php echo e(__('paypal')); ?></label>
                                                        </div>
                                                    <?php endif; ?>

                                                    <?php if($setting->stripe == 1): ?>
                                                        <div class="position-relative d-flex align-items-center my-1 ">
                                                            <input type="radio" class="d-none custom_radio" value="stripe" id="stripe" name="payment">
                                                            <label for="stripe" class="position-absolute custom-radio"></label>
                                                            <label for="stripe" class="ms-4 normal-label"><?php echo e(__('Stripe')); ?></label>
                                                        </div>
                                                    <?php endif; ?>

                                                    <?php if($setting->paystack == 1): ?>
                                                        <div class="position-relative d-flex align-items-center my-1 ">
                                                            <input type="radio" class="d-none custom_radio" value="paystack" id="paystack" name="payment">
                                                            <label for="paystack" class="position-absolute custom-radio"></label>
                                                            <label for="paystack" class="ms-4 normal-label"><?php echo e(__('Paystack')); ?></label>
                                                        </div>
                                                    <?php endif; ?>

                                                    <?php if($setting->flutterwave == 1): ?>                                                    
                                                        <div class="position-relative d-flex align-items-center my-1 ">
                                                            <input type="radio" class="d-none custom_radio" value="flutterwave" id="flutterwave" name="payment">
                                                            <label for="flutterwave" class="position-absolute custom-radio"></label>
                                                            <label for="flutterwave" class="ms-4 normal-label"><?php echo e(__('Flutterwave')); ?></label>
                                                        </div>
                                                    <?php endif; ?>

                                                    <?php if($setting->razor == 1): ?>
                                                        <div class="position-relative d-flex align-items-center my-1 ">
                                                            <input type="radio" class="d-none custom_radio" value="razor" id="razorpay" name="payment">
                                                            <label for="razorpay" class="position-absolute custom-radio"></label>
                                                            <label for="razorpay" class="ms-4 normal-label"><?php echo e(__('Razor Pay')); ?></label>
                                                        </div>
                                                    <?php endif; ?>

                                                    <div class="mt-3">
                                                        <div id="paypalPayment" class="paypal_row disp-none">
                                                            <div class="card">
                                                                <div class="paypal_row_body"></div>
                                                            </div>
                                                        </div>

                                                        <div id="stripePayment" class="stripe_row disp-none">
                                                            <div class="alert alert-warning stripe_alert hide" role="alert">
                                                            </div>
                                                            <input type="hidden" name="stripe_publish_key" value="<?php echo e(App\Models\Setting::find(1)->stripe_public_key); ?>">
                                                            <form role="form" method="post" class="require-validation hide customform" data-cc-on-file="false" id="stripe-payment-form">
                                                                <?php echo csrf_field(); ?>
                                                                <div class="row">
                                                                    <div class="col-12">
                                                                        <div class="form-group">
                                                                            <label><?php echo e(__('Email')); ?></label>
                                                                            <input type="email" class="email form-control required" title="Enter Your Email"
                                                                                name="email" required />
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-12">
                                                                        <div class="form-group">
                                                                            <label><?php echo e(__('Card Information')); ?></label>
                                                                            <input type="text" class="card-number required form-control" title="please input only number." pattern="[0-9]{16}" name="card-number" placeholder="1234 1234 1234 1234" title="Card Number" required />
                                                                            <div class="row" class="mt-1">
                                                                                <div class="col-lg-6 pr-0">
                                                                                    <input type="text" class="expiry-date required form-control" name="expiry-date" title="Expiration date" title="please Enter data in MM/YY format." pattern="(0[1-9]|10|11|12)/[0-9]{2}$" placeholder="MM/YY" required />
                                                                                    <input type="hidden" class="card-expiry-month required form-control" name="card-expiry-month" />
                                                                                    <input type="hidden" class="card-expiry-year required form-control" name="card-expiry-year" />
                                                                                </div>

                                                                                <div class="col-lg-6 pl-0">
                                                                                    <input type="text" class="card-cvc required form-control" title="please input only number." pattern="[0-9]{3}" name="card-cvc" placeholder="CVC" title="CVC" required />
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="col-12">
                                                                        <div class="form-group">
                                                                            <label><?php echo e(__('Name on card')); ?></label>
                                                                            <input type="text" class="required form-control" name="name" title="Name on Card" required />
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-12">
                                                                        <div class="form-group text-center">
                                                                            <input type="button" class="btn btn-primary mt-4 btn-submit" value="<?php echo e(__('Pay with stripe')); ?>" />
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                        
                                                        <div id="paystackPayment" class="paystack_row disp-none">
                                                            <div class="card-header"><?php echo e(__('Paystack')); ?></div>
                                                            <div class="card-body">
                                                                <form id="paymentForm">
                                                                    <input type="hidden" id="paystack-public-key" value="<?php echo e(App\Models\Setting::find(1)->paystack_public_key); ?>">
                                                                    <input type="hidden" id="email-address" value="<?php echo e(auth()->user()->email); ?>" required />
                                                                    <div class="form-submit">
                                                                        <input type="button" class="btn btn-primary" onclick="payWithPaystack()" value="<?php echo e(__('Pay with paystack')); ?>">
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                        <div id="flutterPayment" class="flutterwave_row disp-none">
                                                            <form>
                                                                <input type="hidden" name="flutterwave_key" value="<?php echo e($setting->flutterwave_key); ?>">
                                                                <script src="<?php echo e(asset('payment/flutterwave.js')); ?>"></script>
                                                                <div class="w-full px-4 flex gap-3 items-center mt-5 rounded-md h-auto justify-center">
                                                                    <input type="button" class="btn btn-primary" onclick="makePayment()" value="<?php echo e(__('Payment With Flutterwave')); ?>">
                                                                </div>
                                                            </form>
                                                        </div>
                                                        <div id="razorPayment" class="razor_row disp-none">
                                                            <div class="card-header"><?php echo e(__('razor pay')); ?></div>
                                                            <input type="hidden" id="RAZORPAY_KEY" value="<?php echo e($setting->razor_key); ?>">
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col-md-12 text-center">
                                                                        <input type="button" id="paybtn" value="<?php echo e(__('pay')); ?>" class="btn btn-primary">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-5 col-lg-4">
                                                <div class="booking-summery border m-2 rounded-3">
                                                    <div class="booking-card-head p-3 border-bottom">
                                                        <h6><?php echo e(__('Booking Summary')); ?></h6>
                                                    </div>
                                                    <div class="p-3">
                                                        <div
                                                            class="d-flex  flex-sm-row flex-column align-items-sm-center mb-2">
                                                            <div class="booking-card-img  me-3">
                                                                <img src="<?php echo e($doctor->fullImage); ?>" alt="">
                                                            </div>
                                                            <div class="doct-card doctor-info">
                                                                <div class="personalInfo">
                                                                    <div>
                                                                        <h6><?php echo e($doctor->name); ?></h6>
                                                                    </div>
                                                                    <div class="rating d-flex  align-items-center">
                                                                        <i class="bx bxs-star active"></i>
                                                                        <i class="bx bxs-star active"></i>
                                                                        <i class="bx bxs-star active"></i>
                                                                        <i class="bx bxs-star"></i>
                                                                        <i class="bx bxs-star"></i>
                                                                        <span class="d-inline-block average-rating">(0)</span>
                                                                    </div>
                                                                    
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="pb-4 pt-3 border-bottom bill my-2">
                                                            <p class="d-flex justify-content-between"><?php echo e(__('Consulting Fee')); ?>

                                                                <span><?php echo e($setting->currency_symbol); ?>

                                                                    <span class="appointmentFees"><?php echo e($doctor->appointment_fees); ?></span>
                                                                </span>
                                                            </p>
                                                            <p class="d-flex justify-content-between discountLi d-none"><?php echo e(__('Discount amount ')); ?>

                                                                <span><?php echo e($setting->currency_symbol); ?>

                                                                    <span class="discountAmount"></span>
                                                                </span>
                                                            </p>
                                                        </div>
                                                        <div class="pt-3 total-bill pb-2 ">
                                                            <h5 class="d-flex justify-content-between"><?php echo e(__('Total')); ?>

                                                                <p><?php echo e($setting->currency_symbol); ?>

                                                                    <span class="finalAmount total-cost"><?php echo e($doctor->appointment_fees); ?></span>
                                                                </p>
                                                            </h5>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <button type="button" class="btn" id="prev" disabled><?php echo e(__('Prev')); ?></button>
                                    <button type="button" class="btn" id="next"><?php echo e(__('Next')); ?></button>
                                    <a href="javascript:void(0)" onclick="booking()" id="payment" class="btn d-none"><?php echo e(__('Proceed To Pay')); ?></a>
                                </div>
                        </div>
                        <!-- Stapper Over -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-0">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('User Address')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(url('addAddress')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="from" value="add_new">
                        <input type="hidden" name="id">
                        <input type="hidden" name="lat" id="lat" value="22.3039">
                        <input type="hidden" name="lang" id="lng" value="70.8022">
                        <input type="hidden" name="user_id" value="<?php echo e(auth()->user()->id); ?>">
                        <div id="map" class="mapClass"></div>
                        <div class="form-group">
                            <textarea name="address" cols="30" class="form-control" rows="10"><?php echo e(__('Rajkot , Gujrat')); ?></textarea>
                        </div>
                        <div class="modal-footer border-0">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                            <button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <?php if(App\Models\Setting::first()->map_key): ?>
        <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(App\Models\Setting::first()->map_key); ?>&callback=initAutocomplete&libraries=places&v=weekly" async></script>
    <?php endif; ?>
    <script src="<?php echo e(url('assets/js/appointment.js')); ?>"></script>
    <?php if(App\Models\Setting::first()->paypal_sandbox_key): ?>
        <script src="https://www.paypal.com/sdk/js?client-id=<?php echo e(App\Models\Setting::first()->paypal_sandbox_key); ?>&currency=<?php echo e(App\Models\Setting::first()->currency_code); ?>" data-namespace="paypal_sdk"></script>
    <?php endif; ?>
    <script src="<?php echo e(url('payment/razorpay.js')); ?>"></script>
    <script src="<?php echo e(url('payment/stripe.js')); ?>"></script>
    <?php if(App\Models\Setting::first()->paystack_public_key): ?>
        <script src="<?php echo e(url('payment/paystack.js')); ?>"></script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.mainlayout',['active_page' => 'booking'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/doktro/resources/views/website/booking.blade.php ENDPATH**/ ?>