<?php $__env->startSection('title', __('pharmacy Dashboard')); ?>

<?php $__env->startSection('content'); ?>

    <section class="section">
        <?php echo $__env->make('layout.breadcrumb',['title' => __('Pharmacy Dashboard')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="row">
            <div class="col-xl-6 col-sm-6 col-12">
                <div class="card card-statistic-1">
                    <div class="card-icon bg-primary">
                        <i class="far fa-money-bill-alt"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?php echo e(__('Sales Today')); ?></h4>
                        </div>
                        <div class="card-body">
                            <h3><?php echo e($currency); ?><?php echo e($today_sells); ?></h3>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-sm-6 col-12">
                <div class="card card-statistic-1">
                    <div class="card-icon bg-warning">
                        <i class="fas fa-tablets"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?php echo e(__('Total Medicines')); ?></h4>
                        </div>
                        <div class="card-body">
                            <h3><?php echo e($total_medicines); ?></h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-xl-12 col-sm-12 col-12">
                <div class="card card-chart">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e(__('Revenue')); ?></h4>
                    </div>
                    <div class="card-body">
                        <canvas id="revenueChart"></canvas>
                        <input type="hidden" name="years" value="<?php echo e($revenueCharts['label']); ?>">
                        <input type="hidden" name="data" value="<?php echo e($revenueCharts['data']); ?>">
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(url('assets_admin/js/chart.min.js')); ?>"></script>
    <script src="<?php echo e(url('assets_admin/js/chart.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.mainlayout_admin',['activePage' => 'home'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/doktro/resources/views/pharmacyAdmin/home.blade.php ENDPATH**/ ?>