<?php $__env->startSection('title',__('All Pharmacy Medicine')); ?>
<?php $__env->startSection('content'); ?>
<section class="section">
        <?php echo $__env->make('layout.breadcrumb',[
            'title' => __('Medicine'),
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if(session('status')): ?>
        <?php echo $__env->make('superAdmin.auth.status',[
            'status' => session('status')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <?php echo $__env->make('superAdmin.auth.exportButtons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('medicine_add')): ?>
                    <a href="<?php echo e(url('medicines/create')); ?>"><?php echo e(__('Add New')); ?></a>
                <?php endif; ?>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="w-100 display table datatable text-center">
                        <thead>
                            <tr>
                                <th> # </th>
                                <th><?php echo e(__('Image')); ?></th>
                                <th><?php echo e(__('Name')); ?></th>
                                <th><?php echo e(__('Incoming stock')); ?></th>
                                <th><?php echo e(__('Total available Stock')); ?></th>
                                <th><?php echo e(__('Total Sell')); ?></th>
                                <th><?php echo e(__('Price')); ?>(<?php echo e(__('pr Strip')); ?>)</th>
                                <th><?php echo e(__('change stock')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <?php if(Gate::check('medicine_edit') || Gate::check('medicine_delete')): ?>
                                    <th> <?php echo e(__('Action')); ?> </th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $medicines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $medicine): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <a href="<?php echo e($medicine->fullImage); ?>" data-fancybox="gallery2">
                                            <img class="avatar-img rounded-circle" alt="User Image" src="<?php echo e($medicine->fullImage); ?>" height="50" width="50">
                                        </a>
                                    </td>
                                    <td>
                                        <?php echo e($medicine->name); ?>

                                    </td>
                                    <td><?php echo e($medicine->incoming_stock); ?></td>
                                    <td><?php echo e($medicine->total_stock); ?></td>
                                    <td><?php echo e($medicine->use_stock); ?></td>
                                    <td><?php echo e($currency); ?><?php echo e($medicine->price_pr_strip); ?></td>
                                    <th>
                                        <a data-toggle="modal" onclick="display_stock(<?php echo e($medicine->id); ?>)" href="#edit_specialities_details"><?php echo e(__('change available stock')); ?></a>
                                    </th>
                                    <td>
                                        <label class="cursor-pointer">
                                            <input type="checkbox" id="status<?php echo e($medicine->id); ?>" class="custom-switch-input" name="status" onchange="change_status('medicine',<?php echo e($medicine->id); ?>)" <?php echo e($medicine->status == 1 ? 'checked' : ''); ?>>
                                            <span class="custom-switch-indicator"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <?php if(Gate::check('medicine_edit') || Gate::check('medicine_delete')): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('medicine_edit')): ?>
                                            <a class="text-success" href="<?php echo e(url('medicines/'.$medicine->id.'/edit/')); ?>">
                                                <i class="far fa-edit"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('medicine_delete')): ?>
                                            <a class="text-danger" href="javascript:void(0);" onclick="deleteData('medicines',<?php echo e($medicine->id); ?>)">
                                                <i class="far fa-trash-alt"></i>
                                            </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
</section>


<div class="modal fade hide" id="edit_specialities_details" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <form action="<?php echo e(url('medicine/update_stock')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__("change stock")); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="medicine_id">
                    <div class="row form-row">
                        <div class="col-12 col-sm-12">
                            <div class="form-group">
                                <label><?php echo e(__('Total income stocks')); ?></label>
                                <input type="number" required name="incoming_stock" class="form-control incoming_stock">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary"><?php echo e(__('Save changes')); ?></button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.mainlayout_admin',['activePage' => 'medicine'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/doktro/resources/views/pharmacyAdmin/medicine/medicine.blade.php ENDPATH**/ ?>