<?php $__env->startSection('title',__('Show Pharamcy')); ?>
<?php $__env->startSection('content'); ?>

<section class="section">
    <?php echo $__env->make('layout.breadcrumb',[
        'title' => __('Pharmacy Details'),
        'url' => url('pharmacy'),
        'urlTitle' => __('Pharmacy')
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="section_body">
        <div class="card profile-widget mt-5">
            <div class="profile-widget-header">
                <a href="<?php echo e($pharmacy->fullImage); ?>" data-fancybox="gallery2">
                    <img alt="image" src="<?php echo e($pharmacy->fullImage); ?>" class="rounded-circle profile-widget-picture">
                </a>
                <div class="btn-group mb-2 dropleft float-right p-3">
                    <button class="btn btn-primary btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <?php echo e(__('More Details')); ?>

                    </button>
                    <div class="dropdown-menu" x-placement="bottom-start">
                      <a class="dropdown-item" href="<?php echo e(url('medicine/'.$pharmacy->id)); ?>"><?php echo e(__('Medicine')); ?></a>
                      <a class="dropdown-item" href="<?php echo e(url('pharmacy_schedule/'.$pharmacy->id)); ?>"><?php echo e(__('Schedule Timings')); ?></a>
                      <a class="dropdown-item" href="<?php echo e(url('pharmacy_commission/'.$pharmacy->id)); ?>"><?php echo e(__('commission')); ?></a>
                    </div>
                </div>
            </div>
            <div class="profile-widget-description">
                <div class="profile-widget-name"><?php echo e($pharmacy->name); ?></div>
                <?php echo clean($pharmacy->description); ?>

            </div>
        </div>

        <div class="card">
            <div class="card-header justify-content-between">
                <h6><?php echo e(__('Purchased Medicine')); ?></h6>
                <?php echo $__env->make('superAdmin.auth.exportButtons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="w-100 display table datatable">
                        <thead>
                            <tr>
                                <th> # </th>
                                <th><?php echo e(__('Prescription Image')); ?></th>
                                <th><?php echo e(__('User')); ?></th>
                                <th><?php echo e(__('Amount')); ?></th>
                                <th><?php echo e(__('payment type')); ?></th>
                                <th><?php echo e(__('payment status')); ?></th>
                                <th><?php echo e(__('View Medicines')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $medicines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $medicine): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <?php if(isset($medicine['pdf'])): ?>
                                            <a href="<?php echo e(url('prescription/upload/'.$medicine['pdf'])); ?>"  data-fancybox="gallery2">
                                                <?php echo e($medicine['pdf']); ?>

                                            </a>
                                        <?php else: ?>
                                            <?php echo e(__('No prescription available')); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e($medicine->user['name']); ?>

                                    </td>
                                    <td><?php echo e($currency); ?><?php echo e($medicine->amount); ?></td>
                                    <td><?php echo e($medicine->payment_type); ?></td>
                                    <td>
                                        <?php if($medicine->payment_status == 1): ?>
                                            <span class="btn btn-sm bg-success-light"><?php echo e(__('Paid')); ?></span>
                                        <?php else: ?>
                                            <span class="btn btn-sm bg-danger-light"><?php echo e(__('Unpaid')); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td> 
                                    <a href="#edit_specialities_details" onclick="show_medicines(<?php echo e($medicine->id); ?>)" data-toggle="modal" class="text-info">
                                        <i class="far fa-eye"></i>
                                    </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="modal fade hide" id="edit_specialities_details" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__("Medicines Details")); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table">
                    <tbody>
                        <tr>
                            <td><?php echo e(__('shipping At')); ?></td>
                            <td class="shippingAt"></td>
                        </tr>
                        <tr class="shippingAddressTr">
                            <td><?php echo e(__('shipping Adddress')); ?></td>
                            <td class="shippingAddress"></td>
                        </tr>
                        <tr class="shippingAddressTr">
                            <td><?php echo e(__('Delivery Charge')); ?></td>
                            <td class="deliveryCharge"></td>
                        </tr>
                    </tbody>
                </table>
                <table class="table">
                    <thead>
                        <th><?php echo e(__('medicine name')); ?></th>
                        <th><?php echo e(__('medicine qty')); ?></th>
                        <th><?php echo e(__('medicine price')); ?></th>
                    </thead>
                    <tbody  class="tbody">

                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.mainlayout_admin',['activePage' => 'pharmacy'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/doktro/resources/views/superAdmin/pharmacy/show_pharmacy.blade.php ENDPATH**/ ?>