

<?php $__env->startSection('title',__('Commission')); ?>

<?php $__env->startSection('content'); ?>
<section class="section">
    <?php echo $__env->make('layout.breadcrumb',[
        'title' => __('Commission'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="section-body">
        <div class="card">
            <div class="card-header">
                <h4><?php echo e(__('Settlements')); ?></h4>
                <span class="badge badge-success"><?php echo e(__('admin gives to Lab')); ?></span>&nbsp;
                <span class="badge badge-danger"><?php echo e(__('Lab gives to admin')); ?></span>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th><?php echo e(__('duration')); ?></th>
                                <th><?php echo e(__('Report count')); ?></th>
                                <th><?php echo e(__('Admin Earning')); ?></th>
                                <th><?php echo e(__('Lab earning')); ?></th>
                                <th><?php echo e(__('Settles amount')); ?></th>
                                <th><?php echo e(__('view')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $settels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $settel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td id="duration<?php echo e($loop->iteration); ?>"><?php echo e($settel['duration']); ?></td>
                                    <td><?php echo e($settel['d_total_task']); ?></td>
                                    <td><?php echo e($currency); ?><?php echo e($settel['admin_earning']); ?></td>
                                    <td><?php echo e($currency); ?><?php echo e($settel['lab_amount']); ?></td>
                                    <td>
                                        <?php if($settel['d_balance'] > 0): ?>
                                            
                                            <span class="badge badge-success"><?php echo e($currency); ?><?php echo e(abs($settel['d_balance'])); ?></span>
                                        <?php else: ?>
                                            
                                            <span class="badge badge-danger"><?php echo e($currency); ?><?php echo e(abs($settel['d_balance'])); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-primary" onclick="show_lab_settle_details(<?php echo e($loop->iteration); ?>)" data-toggle="modal" data-target="#exampleModal">
                                            <?php echo e(__('Show settlement details')); ?>

                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Show settlement details')); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body details_body">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('layout.mainlayout_admin',['activePage' => 'commission'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/doktro/resources/views/superAdmin/lab/commission.blade.php ENDPATH**/ ?>