

<?php $__env->startSection('title', __('Pathologist name')); ?>

<?php $__env->startSection('content'); ?>

    <section class="section">
        <?php echo $__env->make('layout.breadcrumb',[
        'title' => __('Dashboard'),
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="section_body">
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-primary">
                            <i class="fas fa-vials"></i>
                        </div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h4><?php echo e(__('Total Pathology')); ?></h4>
                            </div>
                            <div class="card-body">
                                <h3><?php echo e($pathology); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-danger">
                            <i class="fas fa-x-ray"></i>
                        </div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h6 class="text-muted"><?php echo e(__('Total Radiology')); ?></h6>
                            </div>
                            <div class="card-body">
                                <h3><?php echo e($radiology); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card">
                    <div class="card-header w-100 text-right d-flex justify-content-between">
                        <h6><?php echo e(__('Todays Report')); ?></h6>
                        <?php echo $__env->make('superAdmin.auth.exportButtons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover text-center mb-0 datatable">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <?php if(auth()->user()->hasRole('super admin')): ?>
                                            <th><?php echo e(__('Laboratory Name')); ?></th>
                                            <th><?php echo e(__('Report')); ?></th>
                                        <?php endif; ?>
                                        <th><?php echo e(__('Prescirption')); ?></th>
                                        <th><?php echo e(__('Date time')); ?></th>
                                        <th><?php echo e(__('Payment Type')); ?></th>
                                        <th><?php echo e(__('Amount')); ?></th>
                                        <th><?php echo e(__('View')); ?></th>
                                        <?php if(auth()->user()->hasRole('laboratory')): ?>
                                            <th><?php echo e(__('Upload Report')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $test_reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $test_report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <?php if(auth()->user()->hasRole('super admin')): ?>
                                                <td><?php echo e($test_report->lab['name']); ?></td>
                                                <td>
                                                    <?php if($test_report->upload_report == null): ?>
                                                        <?php echo e(__('Report Not Availabel.')); ?>

                                                    <?php else: ?>
                                                        <a href="<?php echo e('report_prescription/report/'.$test_report->upload_report); ?>" data-fancybox="gallery2">
                                                            <?php echo e(__('Report')); ?>

                                                        </a>
                                                    <?php endif; ?>
                                                </td>
                                            <?php endif; ?>
                                            <td class="d-flex">
                                                <?php if($test_report->prescription != null): ?>
                                                    <a href="<?php echo e('report_prescription/upload/'.$test_report->prescription); ?>" data-fancybox="gallery2">
                                                        <img src="<?php echo e('report_prescription/upload/'.$test_report->prescription); ?>" alt="Feature Image" width="50px" height="50px">
                                                    </a>
                                                <?php else: ?>
                                                    <?php echo e(__('Prescirption Not available')); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($test_report->date); ?><span class="d-block text-info"><?php echo e($test_report->time); ?></span></td>
                                            <td><?php echo e($test_report->payment_type); ?></td>
                                            <td><?php echo e($currency); ?><?php echo e($test_report->amount); ?></td>
                                            <td>
                                                <a onclick="single_report(<?php echo e($test_report->id); ?>)" class="text-info ml-2" href="#edit_specialities_details" data-toggle="modal">
                                                    <?php echo e(__('View')); ?>

                                                </a>
                                            </td>
                                            <?php if(auth()->user()->hasRole('laboratory')): ?>
                                                <td>
                                                    <?php if($test_report->upload_report == null): ?>
                                                        <a onclick="upload_report(<?php echo e($test_report->id); ?>)" class="text-info ml-2" href="#upload_report" data-toggle="modal">
                                                            <?php echo e(__('Upload Report')); ?>

                                                        </a>
                                                    <?php else: ?>
                                                        <a  class="text-success" href="<?php echo e('report_prescription/report/'.$test_report->upload_report); ?>" data-fancybox="gallery2">
                                                            <?php echo e(__('Report')); ?>

                                                        </a>
                                                    <?php endif; ?>
                                                </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card_fotter">
                        <input type="button" value="delete selected" onclick="deleteAll('doctor_all_delete')" class="btn btn-primary">
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.mainlayout_admin',['activePage' => 'pathologist'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/doktro/resources/views/lab/home.blade.php ENDPATH**/ ?>